/**  @file bta_find_chessboard.h
*
*    @brief This filter finds chessboard corners, marks them and adds metadata needed for calibration
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_FIND_CHESSBOARD_H_INCLUDED
#define BTA_FIND_CHESSBOARD_H_INCLUDED


typedef struct BTA_FltFindChessboardInst {
    BTA_ChannelId channelToProcess;
    float scaleFactor;
    uint8_t edgeCountHor;
    uint8_t edgeCountVert;
    uint8_t drawCorners;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltFindChessboardInst;


BTA_Status BFLTfindChessboardInit(BTA_FltFindChessboardConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTfindChessboardClose(BTA_FltHandle *handle);
BTA_Status BFLTfindChessboardApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif